﻿// See https://aka.ms/new-console-template for more information

Console.BackgroundColor = ConsoleColor.Black;
Console.ForegroundColor = ConsoleColor.Yellow;

Console.WriteLine("You see a door and see it has a 4 digit lock");

int initialPasscode; 
while (true)
{
    string input = GetCode("What is the initial passcode?").ToString();
    
    if (int.TryParse(input, out initialPasscode) && input.Length == 4)
    {
        break; // Valid 4-digit number
    }
    else
    {
        Console.WriteLine("Invalid passcode. Please enter exactly 4 digits.");
    }
}
Door door = new Door(initialPasscode);

while (true)
{
    Console.Write($"The door is {door.DoorState}. What do you want to do? (open, close, lock, unlock, change code) ");
    string? command = Console.ReadLine(); //? accepts null values 

    switch (command)
    {
        case "open":
            door.Open();
            break;
        case "close":
            door.Close();
            break;
        case "lock":
            door.Lock();
            break;
        case "unlock":
            int guess = GetCode("What is the passcode?");
            door.Unlock(guess);
            break;
        case "change code":
            int currentCode = GetCode("What is the current passcode?");
            int newCode = GetCode("What do you want to change it to?");
            door.ChangeCode(currentCode, newCode);
            break;
    }
}

int GetCode(string text)
{
    Console.Write(text + " ");
    return Convert.ToInt32(Console.ReadLine());
}

public class Door
{
    private int Passcode; // Store the passcode
    public DoorState DoorState { get; private set; }

    public Door(int setpasscode)
    {
        Passcode = setpasscode;
        DoorState = DoorState.Locked;
    }

    public void Close()
    {
        if (DoorState == DoorState.Open) DoorState = DoorState.Closed;
    }

    public void Open()
    {
        if (DoorState == DoorState.Closed) DoorState = DoorState.Open;
    }

    public void Lock()
    {
        if (DoorState == DoorState.Closed) DoorState = DoorState.Locked;
    }

    public void Unlock(int passcode)
    {
        if (DoorState == DoorState.Locked && passcode == Passcode) DoorState = DoorState.Closed;
    }

    public void ChangeCode(int oldPasscode, int newPasscode)
    {
        if (oldPasscode != Passcode) Console.WriteLine("current passcode is wrong");
        else if (oldPasscode == Passcode)
        {
            Console.WriteLine("passcode changed!");
            Passcode = newPasscode;
        }
        
    }
}




public enum DoorState{Open, Closed, Locked}